#!/usr/bin/env python3
# vim:ts=4:sts=4:sw=4:expandtab

import argparse
import pathlib
import random
import unicodedata
import cv2

LOCATION = pathlib.Path(__file__).parent.resolve()

parser = argparse.ArgumentParser(prog='Polibiusz Protocol Encoder')
parser.add_argument('--signal-time', type=float, default=0.5)
parser.add_argument('--message', default='δείγμα πρότασης')
parser.add_argument('--harder', action='store_true')

parser.add_argument('--framerate', type=int, default=60)
parser.add_argument('--width', type=int, default=780)
parser.add_argument('--height', type=int, default=780)

parser.add_argument('--output', default='polibiusz.mp4')
parser.add_argument('--codec', default='mp4v')
args = parser.parse_args()

def repeat_count(time = args.signal_time):
    if args.harder:
        time = random.uniform(0.5,1.5)*time
    return int(round(time*args.framerate))

alphabet = 'αβγδεζηθικλμνξοπρστυφχψω'
letter_map = dict()
index = 0
for letter in alphabet:
    letter_map[letter] = (index//5,index%5)
    index += 1
letter_map['ς'] = letter_map['σ']

dimensions = (args.width, args.height)

frame_empty = cv2.resize(cv2.imread(f'{LOCATION}/polibiusz_0.png'), dimensions)
frame_init = cv2.resize(cv2.imread(f'{LOCATION}/polibiusz_init.png'), dimensions)
frame_left = list()
for i in range(5):
    frame_left.append(cv2.resize(cv2.imread(f'{LOCATION}/polibiusz_l{i+1}.png'), dimensions))
frame_right = list()
for i in range(5):
    frame_right.append(cv2.resize(cv2.imread(f'{LOCATION}/polibiusz_r{i+1}.png'), dimensions))

video = cv2.VideoWriter(args.output, cv2.VideoWriter_fourcc(*args.codec), args.framerate, dimensions)

#Puste ręce przez 3 sekundy
for i in range(repeat_count(3)):
    video.write(frame_empty)

#Obie ręce przez 1 kwant czasu
for i in range(repeat_count()):
    video.write(frame_init)

for letter in unicodedata.normalize('NFKD', args.message).lower():
    if not (letter in letter_map or letter.isspace()):
        continue
    print(letter)
    if letter in letter_map:
        #Lewa ręka przez 1 kwant czasu
        for i in range(repeat_count()):
            video.write(frame_left[letter_map[letter][0]])
        #Prawa ręka przez 1 kwant czasu
        for i in range(repeat_count()):
            video.write(frame_right[letter_map[letter][1]])
    else:
        #Puste ręce przez 1 kwant czasu
        for i in range(repeat_count()):
            video.write(frame_empty)

#Puste ręce przez 3 sekundy
for i in range(repeat_count(3)):
    video.write(frame_empty)

cv2.destroyAllWindows()
video.release()
